#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="NavigationGo"
package_title="NavigationGo"
pkg_size="23854"
package_name="com.google.android.apps.navlite"
packagePath=installNavigationGoFiles
deleteFilesPath=deleteNavigationGoFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
"

delete_overlays="
"

file_list="
___app___NavigationGo/NavigationGo.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of NavigationGo
   delete_package "NavigationGo" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing NavigationGo
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "app"
   make_dir "app/NavigationGo"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon.sh";
   update_prop "$propFilePath" "install" "$propFilePath" "NavigationGo" 
   . $COMMONDIR/addon.sh "NavigationGo" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

