#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="ExtraFilesGo"
package_title="ExtraFilesGo"
pkg_size="3076"
package_name=""
packagePath=installExtraFilesGoFiles
deleteFilesPath=deleteExtraFilesGoFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
"

delete_overlays="
"

file_list="
___etc___security___fsverity/play_store_fsi_cert.der
___etc___security___fsverity/gms_fsverity_cert.der
___lib64/libjni_latinimegoogle.so
___lib64/libgdx.so
___lib/libjni_latinimegoogle.so
___etc___sysconfig/d2d_cable_migration_feature.xml
___etc___sysconfig/google_dialergo_experience.xml
___etc___sysconfig/adaptivecharging.xml
___etc___sysconfig/google-install-constraints-package-allowlist.xml
___etc___sysconfig/game_service.xml
___etc___sysconfig/preinstalled-packages-product-pixel-2017-and-newer.xml
___etc___sysconfig/nexus.xml
___etc___sysconfig/dreamliner.xml
___etc___sysconfig/google_go.xml
___etc___sysconfig/GoogleCamera_6gb_or_more_ram.xml
___etc___sysconfig/nga.xml
___etc___sysconfig/google-staged-installer-whitelist.xml
___etc___sysconfig/google.xml
___etc___sysconfig/NikGapps-google-hiddenapi-package-whitelist.xml
___etc___sysconfig/gmsexpress.xml
___etc___sysconfig/quick_tap.xml
___etc___sysconfig/pixel_experience_2017.xml
___etc___sysconfig/google_build.xml
___etc___firmware/music_detector.sound_model_tflite
___etc___firmware/music_detector.sound_model_2
___etc___firmware/music_detector.descriptor
___etc___firmware/music_detector.sound_model
___etc___default-permissions/default-permissions-nikgapps.xml
___etc___permissions/privapp-permissions-google-comms-suite.xml
___etc___permissions/NikGapps-privapp-permissions-google-se.xml
___etc___permissions/NikGapps-privapp-permissions-google-p.xml
___etc___permissions/NikGapps-privapp-permissions-google.xml
___etc___permissions/NikGapps-split-permissions-google.xml
___framework/com.google.android.dialer.support.jar
___framework/com.google.android.maps.jar
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of ExtraFilesGo
   delete_package "ExtraFilesGo" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing ExtraFilesGo
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "etc/security"
   make_dir "etc/security/fsverity"
   make_dir "lib64"
   make_dir "lib"
   make_dir "etc/sysconfig"
   make_dir "etc/firmware"
   make_dir "etc/default-permissions"
   make_dir "etc/permissions"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   script_text="<permissions>
        <!-- Shared library required on the device to get Google Dialer updates from
             Play Store. This will be deprecated once Google Dialer play store
             updates stop supporting pre-O devices. -->
        <library name=\"com.google.android.dialer.support\"
          file=\"$install_partition/framework/com.google.android.dialer.support.jar\" />

        <!-- Starting from Android O and above, this system feature is required for
             getting Google Dialer play store updates. -->
        <feature name=\"com.google.android.apps.dialer.SUPPORTED\" />
        <!-- Feature for Google Dialer Call Recording -->
        <feature name=\"com.google.android.apps.dialer.call_recording_audio\" />
    </permissions>"
       echo -e "$script_text" > $install_partition/etc/permissions/com.google.android.dialer.support.xml
       set_perm 0 0 0644 "$install_partition/etc/permissions/com.google.android.dialer.support.xml"
       update_prop "$install_partition/etc/permissions/com.google.android.dialer.support.xml" "install" "$propFilePath" "$package_title"
       if [ -f "$install_partition/etc/permissions/com.google.android.dialer.support.xml" ]; then
         addToLog "- $install_partition/etc/permissions/com.google.android.dialer.support.xml Successfully Written!" "$package_title"
       fi
       script_text="<permissions>
        <library name=\"com.google.android.maps\"
                file=\"$install_partition/framework/com.google.android.maps.jar\" />
    </permissions>"
       echo -e "$script_text" > $install_partition/etc/permissions/com.google.android.maps.xml
       set_perm 0 0 0644 "$install_partition/etc/permissions/com.google.android.maps.xml"
       update_prop "$install_partition/etc/permissions/com.google.android.maps.xml" "install" "$propFilePath" "$package_title"
       if [ -f "$install_partition/etc/permissions/com.google.android.maps.xml" ]; then
         addToLog "- $install_partition/etc/permissions/com.google.android.maps.xml Successfully Written!" "$package_title"
       fi
       script_text="<permissions>
    <library name=\"com.google.widevine.software.drm\"
    file=\"/system/product/framework/com.google.widevine.software.drm.jar\"/>
    </permissions>"
       echo -e "$script_text" > $install_partition/etc/permissions/com.google.widevine.software.drm.xml
       set_perm 0 0 0644 "$install_partition/etc/permissions/com.google.widevine.software.drm.xml"
       update_prop "$install_partition/etc/permissions/com.google.widevine.software.drm.xml" "install" "$propFilePath" "$package_title"
       if [ -f "$install_partition/etc/permissions/com.google.widevine.software.drm.xml" ]; then
         addToLog "- $install_partition/etc/permissions/com.google.widevine.software.drm.xml Successfully Written!" "$package_title"
       fi
       script_text="<permissions>
    <library name=\"com.google.android.media.effects\"
    file=\"$install_partition/framework/com.google.android.media.effects.jar\" />

    </permissions>"
       echo -e "$script_text" > $install_partition/etc/permissions/com.google.android.media.effects.xml
       set_perm 0 0 0644 "$install_partition/etc/permissions/com.google.android.media.effects.xml"
       update_prop "$install_partition/etc/permissions/com.google.android.media.effects.xml" "install" "$propFilePath" "$package_title"
       if [ -f "$install_partition/etc/permissions/com.google.android.media.effects.xml" ]; then
         addToLog "- $install_partition/etc/permissions/com.google.android.media.effects.xml Successfully Written!" "$package_title"
       fi
        
   chmod 755 "$COMMONDIR/addon.sh";
   update_prop "$propFilePath" "install" "$propFilePath" "ExtraFilesGo" 
   . $COMMONDIR/addon.sh "ExtraFilesGo" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

