/*
 * Decompiled with CFR 0.152.
 */
package com.android.verity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Base64;

public class Utils {
    private static final Map<String, String> ID_TO_ALG = new HashMap<String, String>();
    private static final Map<String, String> ALG_TO_ID = new HashMap<String, String>();

    private static void loadProviderIfNecessary(String string) {
        Object t;
        Class<?> clazz;
        Object object2;
        if (string == null) {
            return;
        }
        try {
            object2 = ClassLoader.getSystemClassLoader();
            clazz = object2 != null ? ((ClassLoader)object2).loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
            return;
        }
        object2 = null;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            object2 = constructor;
            break;
        }
        if (object2 == null) {
            System.err.println("No zero-arg constructor found for " + string);
            System.exit(1);
            return;
        }
        try {
            t = ((Constructor)object2).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return;
        }
        if (!(t instanceof Provider)) {
            System.err.println("Not a Provider class: " + string);
            System.exit(1);
        }
        Security.insertProviderAt((Provider)t, 1);
    }

    static byte[] pemToDer(String string) throws Exception {
        string = string.replaceAll("^-.*", "");
        String string2 = string.replaceAll("-.*$", "");
        return Base64.decode(string2);
    }

    private static PKCS8EncodedKeySpec decryptPrivateKey(byte[] byArray) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        try {
            encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            return null;
        }
        char[] cArray = System.console().readPassword("Password for the private key file: ", new Object[0]);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(cArray));
        Arrays.fill(cArray, '\u0000');
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
        try {
            return encryptedPrivateKeyInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            System.err.println("Password may be bad.");
            throw invalidKeySpecException;
        }
    }

    static PrivateKey loadDERPrivateKey(byte[] byArray) throws Exception {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = Utils.decryptPrivateKey(byArray);
        if (pKCS8EncodedKeySpec == null) {
            pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(pKCS8EncodedKeySpec.getEncoded()));
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(aSN1InputStream.readObject());
        String string = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId();
        return KeyFactory.getInstance(string).generatePrivate(pKCS8EncodedKeySpec);
    }

    static PrivateKey loadPEMPrivateKey(byte[] byArray) throws Exception {
        byte[] byArray2 = Utils.pemToDer(new String(byArray));
        return Utils.loadDERPrivateKey(byArray2);
    }

    static PrivateKey loadPEMPrivateKeyFromFile(String string) throws Exception {
        return Utils.loadPEMPrivateKey(Utils.read(string));
    }

    static PrivateKey loadDERPrivateKeyFromFile(String string) throws Exception {
        return Utils.loadDERPrivateKey(Utils.read(string));
    }

    static PublicKey loadDERPublicKey(byte[] byArray) throws Exception {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    static PublicKey loadPEMPublicKey(byte[] byArray) throws Exception {
        byte[] byArray2 = Utils.pemToDer(new String(byArray));
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    static PublicKey loadPEMPublicKeyFromFile(String string) throws Exception {
        return Utils.loadPEMPublicKey(Utils.read(string));
    }

    static PublicKey loadDERPublicKeyFromFile(String string) throws Exception {
        return Utils.loadDERPublicKey(Utils.read(string));
    }

    static X509Certificate loadPEMCertificate(String string) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            return x509Certificate;
        }
    }

    private static String getSignatureAlgorithm(Key key) throws Exception {
        if ("EC".equals(key.getAlgorithm())) {
            int n;
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            if (key instanceof PublicKey) {
                ECPublicKeySpec eCPublicKeySpec = keyFactory.getKeySpec(key, ECPublicKeySpec.class);
                n = eCPublicKeySpec.getParams().getCurve().getField().getFieldSize();
            } else if (key instanceof PrivateKey) {
                ECPrivateKeySpec eCPrivateKeySpec = keyFactory.getKeySpec(key, ECPrivateKeySpec.class);
                n = eCPrivateKeySpec.getParams().getCurve().getField().getFieldSize();
            } else {
                throw new InvalidKeySpecException();
            }
            if (n <= 256) {
                return "SHA256withECDSA";
            }
            if (n <= 384) {
                return "SHA384withECDSA";
            }
            return "SHA512withECDSA";
        }
        if ("RSA".equals(key.getAlgorithm())) {
            return "SHA256withRSA";
        }
        throw new IllegalArgumentException("Unsupported key type " + key.getAlgorithm());
    }

    static AlgorithmIdentifier getSignatureAlgorithmIdentifier(Key key) throws Exception {
        String string = ALG_TO_ID.get(Utils.getSignatureAlgorithm(key));
        if (string == null) {
            throw new IllegalArgumentException("Unsupported key type " + key.getAlgorithm());
        }
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(string));
    }

    static boolean verify(PublicKey publicKey, byte[] byArray, byte[] byArray2, AlgorithmIdentifier algorithmIdentifier) throws Exception {
        String string = ID_TO_ALG.get(algorithmIdentifier.getAlgorithm().getId());
        if (string == null) {
            throw new IllegalArgumentException("Unsupported algorithm " + algorithmIdentifier.getAlgorithm());
        }
        Signature signature = Signature.getInstance(string);
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(byArray2);
    }

    static byte[] sign(PrivateKey privateKey, byte[] byArray) throws Exception {
        Signature signature = Signature.getInstance(Utils.getSignatureAlgorithm(privateKey));
        signature.initSign(privateKey);
        signature.update(byArray);
        return signature.sign();
    }

    static byte[] read(String string) throws Exception {
        File file = new File(string);
        long l = file.length();
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        for (long i = 0L; i < l; i += (long)fileInputStream.read(byArray, (int)i, (int)(l - i))) {
        }
        fileInputStream.close();
        return byArray;
    }

    static void write(byte[] byArray, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    static {
        ID_TO_ALG.put(X9ObjectIdentifiers.ecdsa_with_SHA256.getId(), "SHA256withECDSA");
        ID_TO_ALG.put(X9ObjectIdentifiers.ecdsa_with_SHA384.getId(), "SHA384withECDSA");
        ID_TO_ALG.put(X9ObjectIdentifiers.ecdsa_with_SHA512.getId(), "SHA512withECDSA");
        ID_TO_ALG.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1withRSA");
        ID_TO_ALG.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256withRSA");
        ID_TO_ALG.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512withRSA");
        ALG_TO_ID.put("SHA256withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256.getId());
        ALG_TO_ID.put("SHA384withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384.getId());
        ALG_TO_ID.put("SHA512withECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512.getId());
        ALG_TO_ID.put("SHA1withRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption.getId());
        ALG_TO_ID.put("SHA256withRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
        ALG_TO_ID.put("SHA512withRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption.getId());
    }
}

